# Данный пример получает данные с канала Х9 в режиме с общей землей и выводит значение в вольтах в консоль

from lpciePy import X502
from lpciePy.constants import Streams, LchMode, SyncMode, AdcRange, ProcFlags

from common import find_devices, select_device


def configure_device(device: X502):

    device.SetSyncMode(SyncMode.X502_SYNC_INTERNAL) # Устанавливаем внутреннюю синхронизацию
    device.StreamsStop() # Останавливаем все потоки данных
    device.StreamsDisable(Streams.X502_STREAM_ALL_IN | Streams.X502_STREAM_ALL_OUT) # Запрещаем все потоки

    device.SetLChannelCount(1) # Используем 1 логический канал
    # 1 логический канал соответствует Х9 в режиме с общей землей и диапазоном 10В
    device.SetLChannel(0, 8, LchMode.X502_LCH_MODE_COMM, AdcRange.X502_ADC_RANGE_10, 0)
    device.SetSyncMode(SyncMode.X502_SYNC_INTERNAL) # Устанавливаем внутреннюю синхронизацию

    device.StreamsEnable(Streams.X502_STREAM_ADC) # Разрешаем поток на ввод с АЦП
    device.Configure() # Записываем конфигурацию в устройство


def get_data(device: X502):
    try:
        while True:
            data = device.Recv(1000) # Получаем данные из модуля
            adc, _ = device.ProcessData(data, 500, None, ProcFlags.X502_PROC_FLAGS_VOLT) # Разбираем данные с модуля
            if adc:
                for i in adc:
                    print("%+.16f" % i, end='\r')
    except KeyboardInterrupt:
        return


def print_info(device: X502):
    info = device.GetDevInfo()
    print(info)

def main():

    # ВАЖНО!! Необходимо оставлять переменные которые содержат записи об устройствах "живыми" до вызова OpenByDevRecord().
    # Иначе, вызовы вида  select_device(find_devices()) и X502.OpenByDevRecord(select_device(list)) приведут к ошибке сегментации,
    # так как временный объект, который создается при вложенных вызовах, будет освобожден раньше времени, что приведёт к ошибке use-after-free

    list = find_devices() # Получаем список всех подключенных устройств
    record = select_device(list) # Выбираем устройство
    device = X502.OpenByDevRecord(record) # Открываем выбранное устройство


    print_info(device)
    configure_device(device)

    device.StreamsStart()

    get_data(device)



if __name__ == "__main__":
    main()