from datetime import datetime
import math

from lpciePy import X502, Streams, SyncMode, E502, TimestampManager
from common import find_devices, select_device



def configure(device):

    device.SetSyncMode(SyncMode.X502_SYNC_INTERNAL) # Устанавливаем внутреннюю синхронизацию
    device.StreamsStop() # Останавливаем все потоки данных
    device.StreamsDisable(Streams.X502_STREAM_ALL_IN | Streams.X502_STREAM_ALL_OUT) # Запрещаем все потоки

    outFreq = device.SetAdcFreq(250000, None) # Устанавливаем частоту вывода ЦАП
    device.StreamsEnable(Streams.X502_STREAM_ADC) # Разрешаем поток данных для первого канала ЦАП
    device.Configure() # Записываем настройки в модуль

    return outFreq


if __name__ == '__main__':

    list = find_devices()
    record = select_device(list)
    device = X502.OpenByDevRecord(record)

    freq = configure(device)
    E502_REGS_ARM_TIME_CTRL = 0x0110
    device.FpgaRegWrite(E502_REGS_ARM_TIME_CTRL, 1)

    device.StreamsStart()

    data = []
    for i in range(100):
        data += device.Recv(5000)

    adc_data = device.ProcessData(data, len(data), None)

    tstp = TimestampManager(25000, None)

    for i, cnt in enumerate(data):
        tstp.process_word(cnt)
        if i % 250 == 0:
            print(f'Lock status: {tstp.get_lock_status()}: {tstp.get_lock_status() == True}')


            lpcie_tstp = tstp.get_current_word_time()
            dt_timestamp = datetime.fromtimestamp(lpcie_tstp >> 31)
            subsecs = 1.0 / (1 << 31) * float(lpcie_tstp & 0x7FFFFFFF)
            print(f'{lpcie_tstp >> 31}:{dt_timestamp} + {subsecs}s')