from lpciePy import DevRecordsList, E502, E16, L502, EthSvcBrowse, t_x502_devrec

def find_devices() -> DevRecordsList:
    device_list = L502.GetDevRecordsList()
    device_list += E16.GetDevRecordsList()
    device_list += E502.GetDevRecordsList()


    with EthSvcBrowse() as browser:

        for event in browser.get_event():
            device_list += E502.MakeDevRecordByEthSvc(event)

    return device_list


def select_device(device_list: DevRecordsList) -> t_x502_devrec:

    for i, record in enumerate(device_list):
        print(f"#{i+1}: Name: {record.devname}, serial: {record.serial}, interface: {record.iface}")

    num = 0
    while True:
        out_str = f"Select device (1-{len(device_list)}): " if len(device_list) > 0 else "No devices found"
        num = int(input(out_str))
        if num <= len(device_list) and num > 0:
            break
        else:
            print("Invalid index")

    return device_list[num-1]