/*
           
       LTR51.
            ,    
           :
    ltr51_interval  slot crate_serial srvip
    :
        slot         -   ( 1  16)
        crate_serial -    (   )
        srvip        - ip- LTR- (     )
     :    ,       

       ,    1.30.0    
         TTF-     
           .

              
     M  N      .
            , 
     REQ_FRONT_CNT-     .
       -   MAX_MEAS_INTERVAL_MS    
        .
            MIN_FRONT_INTERVAL_MS .

         ,   
       .

           Windows   CTRL+C  Linux

      VisualStudio:
          Visual Studio,     
    ( (Project) ->  (Properties) ->   (Configuration Properties)
    -> /++ ->  (General) ->    (Additional Include Directories))
            (ltr51api.h    
         ltr/include   )
        .lib   <  >/lib/msvc
    ( (Project) ->  (Properties) ->   (Configuration Properties) ->
     (Linker) ->  (General) ->    (Additional Library Directories)).

    !:      Visual Studio    
       ,    :
      (File) ->    (Advanced Save Options)...
        (Encoding)   (UTF8,  )/Unicode (UTF-8 with signature)
        .    ,   
           ( Consolas).
*/

#include "ltr/include/ltr51api.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef _WIN32
#include <locale.h>
#include <conio.h>
#else
#include <signal.h>
#include <unistd.h>
#endif


/*       */
#define MIN_FRONT_INTERVAL_MS  2
/*      */
#define MAX_MEAS_INTERVAL_MS  500000
/*  ,     */
#define REQ_FRONT_CNT    2
/*    .   =>    */
#define LTR51_TTF_FILE ""

typedef struct {
    int slot;
    const char *serial;
    DWORD addr;
} t_open_param;


static int f_out = 0;
#ifndef _WIN32
/*     Linux */
static void f_abort_handler(int sig) {
    f_out = 1;
}
#endif

static int f_get_params(int argc, char** argv, t_open_param* par) {
    int err = 0;
    par->slot = LTR_CC_CHNUM_MODULE1;
    par->serial = "";
    par->addr = LTRD_ADDR_DEFAULT;


    if (argc > 1)
        par->slot = atoi(argv[1]);
    if (argc > 2)
        par->serial = argv[2];
    if (argc > 3) {
        int a[4],i;
        if (sscanf(argv[3], "%d.%d.%d.%d", &a[0], &a[1], &a[2], &a[3])!=4) {
            fprintf(stderr, "   !!\n");
            err = -1;
        }

        for (i=0; (i < 4) && !err; i++) {
            if ((a[i]<0) || (a[i] > 255)) {
                fprintf(stderr, "   !!\n");
                err = -1;
            }
        }

        if (!err) {
            par->addr = (a[0] << 24) | (a[1]<<16) | (a[2]<<8) | a[3];
        }
    }
    return err;
}

int main(int argc, char** argv) {
    INT err = LTR_OK;
    TLTR51 hltr51;
    t_open_param par;
#ifndef _WIN32
    struct sigaction sa;
    /*   Linux      ,
           */
    sa.sa_handler = f_abort_handler;
    sigaction(SIGTERM, &sa, NULL);
    sigaction(SIGINT, &sa, NULL);
    sigaction(SIGABRT, &sa, NULL);
#endif


#ifdef _WIN32
    setlocale(LC_ALL, "");
#endif

    err = f_get_params(argc, argv, &par);

    if (!err) {
        LTR51_Init(&hltr51);
        err = LTR51_Open(&hltr51, par.addr, LTRD_PORT_DEFAULT, par.serial, par.slot,
                         LTR51_TTF_FILE);

        if (err!=LTR_OK) {
            fprintf(stderr, "   .  %d (%s)\n",
                    err, LTR51_GetErrorString(err));
        } else {
            double HighThreshold, LowThreshold;
            printf("  . :\n  : %s\n  : %s\n"
                   "  : %s\n   : %s\n  : %s\n",
                   hltr51.ModuleInfo.Name,
                   hltr51.ModuleInfo.Serial,
                   hltr51.ModuleInfo.FirmwareVersion,
                   hltr51.ModuleInfo.FirmwareDate,
                   hltr51.ModuleInfo.FPGA_Version
                   );
            fflush(stdout);

            
            HighThreshold = 4;
            LowThreshold = 1;
            /*         ( ) */
            hltr51.LChQnt = 2;
            hltr51.LChTbl[0] = LTR51_CreateLChannel(1, &HighThreshold, &LowThreshold,
                                                    LTR51_THRESHOLD_RANGE_10V, LTR51_EDGE_MODE_RISE);
            hltr51.LChTbl[1] = LTR51_CreateLChannel(2, &HighThreshold, &LowThreshold,
                                                    LTR51_THRESHOLD_RANGE_10V, LTR51_EDGE_MODE_RISE);
            hltr51.AcqTime = 1000;

            /*  Base  FS   */
            hltr51.SetUserPars = TRUE;
            hltr51.Fs = LTR51_FS_MAX; /*  .   . 
                                         500 K */
            /*  base,        2 
             *     ,   
             *     , 
             *        */
            hltr51.Base = (WORD)(((double)MIN_FRONT_INTERVAL_MS * hltr51.Fs/1000)/2);


            err = LTR51_Config(&hltr51);
            if (err!=LTR_OK) {
                fprintf(stderr, "   !  %d:%s\n",
                        err, LTR51_GetErrorString(err));
            } else {
                printf("  :\n   = %.3f \n  BASE = %d\n   = %d \n    = %d\n",
                       hltr51.Fs, hltr51.Base, hltr51.AcqTime, hltr51.TbaseQnt);
                fflush(stdout);
            }

            if (err==LTR_OK) {
                /*      */
                DWORD read_cnt = 2*LTR51_CHANNEL_CNT*hltr51.TbaseQnt;
                DWORD res_size = hltr51.LChQnt*hltr51.TbaseQnt;
                DWORD *rbuf = malloc(read_cnt*sizeof(rbuf[0]));
                DWORD *out_res = malloc(res_size*sizeof(out_res[0]));
                struct {
                    int fnd_fronts; /* ,     */
                    DWORD cntr; /* -  ,     */
                } *ch_info = calloc(hltr51.LChQnt, sizeof(ch_info[0]));
                DWORD max_cntr;
                /*  -  ,  
                 *    */
                max_cntr =  (DWORD)((double)MAX_MEAS_INTERVAL_MS*hltr51.Fs/1000 + 0.5);




                if ((rbuf==NULL) || (out_res==NULL) || (ch_info==NULL)) {
                    err = LTR_ERROR_MEMORY_ALLOC;
                    fprintf(stderr, "  !\n");
                } else {
                    /*    */
                    err = LTR51_Start(&hltr51);
                    if (err!=LTR_OK)       {
                        fprintf(stderr, "   !  %d:%s\n",
                                err, LTR51_GetErrorString(err));
                    } else {
                        INT stop_err;

                        DWORD tout = LTR51_CalcTimeOut(&hltr51, hltr51.TbaseQnt);

                        printf("   !    %s\n",
#ifdef _WIN32
                           " "
#else
                           "CTRL+C"
#endif
                           );

                        /*       , 
                         *       */
                        while ((err==LTR_OK) && !f_out) {
                            INT recvd = LTR51_Recv(&hltr51, rbuf, NULL, read_cnt, tout);
                            if (recvd<0) {
                                err = recvd;
                                fprintf(stderr, "  .  %d:%s\n",
                                        err, LTR51_GetErrorString(err));
                            } else if (recvd!=(INT)read_cnt) {
                                fprintf(stderr, "  .  %d,  %d\n",
                                        read_cnt, recvd);
                                err = LTR_ERROR_RECV_INSUFFICIENT_DATA;
                            } else {
                                err = LTR51_ProcessData(&hltr51, rbuf, out_res, NULL, (DWORD*)&recvd);
                                if (err!=LTR_OK) {
                                    fprintf(stderr, "  .  %d:%s\n",
                                            err, LTR51_GetErrorString(err));
                                } else {
                                    INT ch;
                                    INT i;

                                    for (i=0; i < recvd; i+=hltr51.LChQnt) {
                                        for (ch=0; ch < hltr51.LChQnt; ch++) {
                                            DWORD n,m;
                                            BOOL check_drop = FALSE;
                                            n = (out_res[i+ch]>>16)&0xFFFF;
                                            m = (out_res[i+ch]&0xFFFF);
                                            if (n!=0) {
                                                if (n > 1) {
                                                    printf(" %d: %d     !!  !\n", ch+1, n);
                                                    /*    ,
                                                     *       .
                                                     *   ,     
                                                     *        */
                                                    ch_info[ch].fnd_fronts = 1;
                                                    ch_info[ch].cntr = m;
                                                } else {
                                                    if (ch_info[ch].fnd_fronts == 0) {
                                                        printf(" %d:   \n", ch+1);
                                                        ch_info[ch].fnd_fronts = TRUE;
                                                        ch_info[ch].cntr = m;
                                                    } else if (ch_info[ch].fnd_fronts == (REQ_FRONT_CNT-1)) {
                                                        double period_ms;
                                                        ch_info[ch].cntr += (hltr51.Base - m);
                                                        period_ms = 1000.*ch_info[ch].cntr/hltr51.Fs;
                                                        printf(" %d:   .   : %.2f \n",
                                                               ch+1, period_ms);
                                                        /*       */
                                                        ch_info[ch].cntr = m;
                                                        ch_info[ch].fnd_fronts = 1;
                                                    } else {
                                                        /*    
                                                         *   
                                                         *   -   */
                                                        ch_info[ch].fnd_fronts++;
                                                        ch_info[ch].cntr+=hltr51.Base;
                                                        check_drop = TRUE;
                                                        printf(" %d:    %d\n",
                                                               ch+1, ch_info[ch].fnd_fronts);
                                                    }
                                                }
                                            } else {
                                                /* n==0 => hltr51.Base 
                                                 *    => 
                                                 *    */
                                                if (ch_info[ch].fnd_fronts) {
                                                    ch_info[ch].cntr+=hltr51.Base;
                                                    check_drop = TRUE;
                                                }                                                    
                                            }

                                            /* ,    
                                             *     */
                                            if (check_drop && (ch_info[ch].cntr > max_cntr)) {
                                                printf(" %d:       \n", ch+1);
                                                ch_info[ch].fnd_fronts = 0;
                                                ch_info[ch].cntr = 0;
                                            }
                                        }
                                    }
                                }
                            }

#ifdef _WIN32
                            /*      */
                            if (err==LTR_OK) {
                                if (_kbhit())
                                    f_out = 1;
                            }
#endif
                        } /* for (i=0 ; (err==LTR_OK) && !f_out; i++) */



                        stop_err = LTR51_Stop(&hltr51);
                        if (stop_err!=LTR_OK) {
                            fprintf(stderr, "   .  %d:%s\n",
                                    stop_err, LTR51_GetErrorString(stop_err));
                            if (err==LTR_OK)
                                err = stop_err;
                        } else {
                            printf("   !\n");
                        }
                    }
                }


                free(rbuf);
                free(out_res);
                free(ch_info);
            }
        }

        LTR51_Close(&hltr51);
    }

    return err;
}
