/*
            LTR51.
            ,    
           :
    ltr51_interval  slot crate_serial srvip
    :
        slot         -   ( 1  16)
        crate_serial -    (   )
        srvip        - ip-  ltrd  LtrServer (     )
     :    ,       

       ,    1.30.0    
         TTF-     
        (Windows)     (Linux).

              .
      AcqTime        .

         ,   
       .

           Windows   CTRL+C  Linux

      VisualStudio:
          Visual Studio,     
    ( (Project) ->  (Properties) ->   (Configuration Properties)
    -> /++ ->  (General) ->    (Additional Include Directories))
            (ltr51api.h    
         ltr/include   )
        .lib   <  >/lib/msvc
    ( (Project) ->  (Properties) ->   (Configuration Properties) ->
     (Linker) ->  (General) ->    (Additional Library Directories)).

    !:      Visual Studio    
       ,    :
      (File) ->    (Advanced Save Options)...
        (Encoding)   (UTF8,  )/Unicode (UTF-8 with signature)
        .    ,   
           ( Consolas).
*/

#include "ltr/include/ltr51api.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef _WIN32
#include <locale.h>
#include <conio.h>
#else
#include <signal.h>
#include <unistd.h>
#endif

/*    .   =>    */
#define LTR51_TTF_FILE ""

typedef struct {
    int slot;
    const char *serial;
    DWORD addr;
} t_open_param;


static int f_out = 0;
#ifndef _WIN32
/*     Linux */
static void f_abort_handler(int sig) {
    f_out = 1;
}
#endif

static int f_get_params(int argc, char** argv, t_open_param* par) {
    int err = 0;
    par->slot = LTR_CC_CHNUM_MODULE1;
    par->serial = "";
    par->addr = LTRD_ADDR_DEFAULT;


    if (argc > 1)
        par->slot = atoi(argv[1]);
    if (argc > 2)
        par->serial = argv[2];
    if (argc > 3) {
        int a[4],i;
        if (sscanf(argv[3], "%d.%d.%d.%d", &a[0], &a[1], &a[2], &a[3])!=4) {
            fprintf(stderr, "   !!\n");
            err = -1;
        }

        for (i=0; (i < 4) && !err; i++) {
            if ((a[i]<0) || (a[i] > 255)) {
                fprintf(stderr, "   !!\n");
                err = -1;
            }
        }

        if (!err) {
            par->addr = (a[0] << 24) | (a[1]<<16) | (a[2]<<8) | a[3];
        }
    }
    return err;
}

int main(int argc, char** argv) {
    INT err = LTR_OK;
    TLTR51 hltr51;
    t_open_param par;
#ifndef _WIN32
    struct sigaction sa;
    /*   Linux      ,
           */
    sa.sa_handler = f_abort_handler;
    sigaction(SIGTERM, &sa, NULL);
    sigaction(SIGINT, &sa, NULL);
    sigaction(SIGABRT, &sa, NULL);
#endif


#ifdef _WIN32
    setlocale(LC_ALL, "");
#endif

    err = f_get_params(argc, argv, &par);
    if (!err) {
        LTR51_Init(&hltr51);
        err = LTR51_Open(&hltr51, par.addr, LTRD_PORT_DEFAULT, par.serial, par.slot,
                         LTR51_TTF_FILE);

        if (err!=LTR_OK) {
            fprintf(stderr, "   .  %d (%s)\n",
                    err, LTR51_GetErrorString(err));
        } else {
            double HighThreshold, LowThreshold;
            printf("  . :\n  : %s\n  : %s\n"
                   "  : %s\n   : %s\n  : %s\n",
                   hltr51.ModuleInfo.Name,
                   hltr51.ModuleInfo.Serial,
                   hltr51.ModuleInfo.FirmwareVersion,
                   hltr51.ModuleInfo.FirmwareDate,
                   hltr51.ModuleInfo.FPGA_Version
                   );
            fflush(stdout);

            /*      2-  .
             *  FS  Base    */
            hltr51.AcqTime = 1000;

            hltr51.LChQnt = 2;
            HighThreshold = 0.7;
            LowThreshold = 0.3;
            hltr51.LChTbl[0] = LTR51_CreateLChannel(1, &HighThreshold, &LowThreshold,
                                                    LTR51_THRESHOLD_RANGE_10V, LTR51_EDGE_MODE_RISE);
            hltr51.LChTbl[1] = LTR51_CreateLChannel(2, &HighThreshold, &LowThreshold,
                                                    LTR51_THRESHOLD_RANGE_10V, LTR51_EDGE_MODE_FALL);


            err = LTR51_Config(&hltr51);
            if (err!=LTR_OK) {
                fprintf(stderr, "   !  %d:%s\n",
                        err, LTR51_GetErrorString(err));
            } else {
                printf("  :\n   = %.3f \n  BASE = %d\n   = %d \n    = %d\n",
                       hltr51.Fs, hltr51.Base, hltr51.AcqTime, hltr51.TbaseQnt);
                fflush(stdout);
            }

            if (err==LTR_OK) {
                /*      */
                DWORD read_cnt = 2*LTR51_CHANNEL_CNT*hltr51.TbaseQnt;
                DWORD *rbuf = malloc(read_cnt*sizeof(rbuf[0]));
                double *freqs = malloc(hltr51.LChQnt*sizeof(double));
                if ((rbuf==NULL) || (freqs==NULL)) {
                    err = LTR_ERROR_MEMORY_ALLOC;
                    fprintf(stderr, "  !\n");
                } else {
                    /*    */
                    err = LTR51_Start(&hltr51);
                    if (err!=LTR_OK) {
                        fprintf(stderr, "   !  %d:%s\n",
                                err, LTR51_GetErrorString(err));
                    } else {
                        DWORD tout = LTR51_CalcTimeOut(&hltr51, hltr51.TbaseQnt);
                        DWORD block_num = 0;
                        INT stop_err;

                        printf("   !    %s\n",
#ifdef _WIN32
                           " "
#else
                           "CTRL+C"
#endif
                           );

                        /*       , 
                         *       */
                        while ((err==LTR_OK) && !f_out) {
                            INT recvd = LTR51_Recv(&hltr51, rbuf, NULL, read_cnt, tout);
                            if (recvd<0) {
                                err = recvd;
                                fprintf(stderr, "  .  %d:%s\n",
                                        err, LTR51_GetErrorString(err));
                            } else if (recvd!=(INT)read_cnt) {
                                fprintf(stderr, "  .  %d,  %d\n",
                                        read_cnt, recvd);
                                err = LTR_ERROR_RECV_INSUFFICIENT_DATA;
                            } else {
                                /*      
                                 *  .  
                                 *  N  M .   ltr51_interval */
                                err = LTR51_ProcessData(&hltr51, rbuf, NULL, freqs, (DWORD*)&recvd);
                                if (err!=LTR_OK){
                                    fprintf(stderr, "  .  %d:%s\n",
                                            err, LTR51_GetErrorString(err));
                                } else {
                                    INT ch;
                                    printf("\n %d:", block_num+1);
                                    for (ch=0; ch < hltr51.LChQnt; ch++) {
                                        printf("   %2d: f=%.5f",
                                               ch+1, freqs[ch]);
                                    }
                                    fflush(stdout);
                                    block_num++;
                                }
                            }

#ifdef _WIN32
                            /*      */
                            if (err==LTR_OK) {
                                if (_kbhit())
                                    f_out = 1;
                            }
#endif
                        }



                        stop_err = LTR51_Stop(&hltr51);
                        if (stop_err!=LTR_OK) {
                            fprintf(stderr, "   .  %d:%s\n",
                                    stop_err, LTR51_GetErrorString(stop_err));
                            if (err==LTR_OK)
                                err = stop_err;
                        } else {
                            printf("   !\n");
                        }
                    }
                }
                free(rbuf);
                free(freqs);
            }
        }

        LTR51_Close(&hltr51);
    }

    return err;
}
