/*        LTR35   .
        .
         CFG_USED_DAC_CH_CNT,  
       sig_amps (  ), sig_offs (  )
     sig_freq_mul (     ).
       CFG_DIGOUT_ENABLE == TRUE,    
      (    ).
    CFG_OUT_CH_PT_CNT        .
           
     .

            ,    
           :
    ltr35_ring  slot crate_serial srvip
    :
        slot         -   ( 1  16)
        crate_serial -    (   )
        srvip        - ip-  ltrd  LtrServer (     )
     :    ,       

      VisualStudio:
          Visual Studio,     
    ( (Project) ->  (Properties) ->   (Configuration Properties)
    -> /++ ->  (General) ->    (Additional Include Directories))
            (ltr35api.h    
         ltr/include   )
        .lib   <  >/lib/msvc
    ( (Project) ->  (Properties) ->   (Configuration Properties) ->
     (Linker) ->  (General) ->    (Additional Library Directories)).

    !:      Visual Studio    
       ,    :
      (File) ->    (Advanced Save Options)...
        (Encoding)   (UTF8,  )/Unicode (UTF-8 with signature)
        .
*/
#include "ltr/include/ltr35api.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#ifdef _WIN32
#include <locale.h>
#include <conio.h>
#else
#include <signal.h>
#include <unistd.h>
#endif


#ifndef M_PI
    #define M_PI 3.1415926535897932384626433832795
#endif


#define CFG_OUT_FREQ                192000  /*     ( 192, 96  48 ) */
#define CFG_USED_DAC_CH_CNT         8       /*         */
#define CFG_DIGOUT_ENABLE           TRUE    /*      */
#define CFG_FORMAT_24               TRUE    /*  24-    ( FALSE - 20 )*/
#define CFG_OUT_CH_PT_CNT           48000   /*         */


/*    (   CFG_USED_DAC_CH_CNT ) */
static const double sig_amps[LTR35_DAC_CHANNEL_CNT]   = {5.,       2.,   0.,   0.,   0.,   0.,   0.,   0.};
static const double sig_offs[LTR35_DAC_CHANNEL_CNT]   = {5.,       5.,   0.,   0.,   0.,   0.,   0.,   0.};
static const int sig_freq_mul[LTR35_DAC_CHANNEL_CNT]  = {1,        2,    3,    4,    5,    6,    7,    8};



typedef struct {
    int slot;
    const char *serial;
    DWORD addr;
} t_open_param;


/*      */
static int f_out = 0;

#ifndef _WIN32
/*     Linux */
static void f_abort_handler(int sig) {
    f_out = 1;
}
#endif

/*    .   ,  
 *   :
 * 1  -   ( 1  16)
 * 2  -   
 * 3  - ip-  */
static int f_get_params(int argc, char** argv, t_open_param* par) {
    int err = 0;
    par->slot = LTR_CC_CHNUM_MODULE1;
    par->serial = "";
    par->addr = LTRD_ADDR_DEFAULT;


    if (argc > 1)
        par->slot = atoi(argv[1]);
    if (argc > 2)
        par->serial = argv[2];
    if (argc > 3) {
        int a[4],i;
        if (sscanf(argv[3], "%d.%d.%d.%d", &a[0], &a[1], &a[2], &a[3])!=4) {
            fprintf(stderr, "  IP-!!\n");
            err = -1;
        }

        for (i=0; (i < 4) && !err; i++) {
            if ((a[i]<0) || (a[i] > 255)) {
                fprintf(stderr, " IP-!!\n");
                err = -1;
            }
        }

        if (!err) {
            par->addr = (a[0] << 24) | (a[1]<<16) | (a[2]<<8) | a[3];
        }
    }
    return err;
}


/*    ch_pt_cnt      .
 *  ch_cur_phases        ,
 *     */
static int f_send_data(TLTR35 *phltr35, DWORD ch_pt_cnt) {
    INT err = 0;
    INT ch;
    DWORD i;
    DWORD dac_pt_cnt = 0;
    DWORD dout_pt_cnt = 0;
    DWORD snd_wrds_cnt = 0;
    DWORD *wrds = NULL;
    double *dac_data = NULL;
#if CFG_DIGOUT_ENABLE
    DWORD *dout_data = NULL;
#endif


    /* -          RAM     */
    dac_pt_cnt = phltr35->State.SDRAMChCnt*ch_pt_cnt;
#if CFG_DIGOUT_ENABLE
    /*           */
    dout_pt_cnt = ch_pt_cnt;
#endif


    /*     1  2    
     *   .  */
    snd_wrds_cnt = (dac_pt_cnt + dout_pt_cnt) * ((phltr35->Cfg.OutDataFmt == LTR35_OUTDATA_FORMAT_24) ? 2 : 1);

    /*      */
    wrds = (DWORD*)malloc(snd_wrds_cnt * sizeof(wrds[0]));
    dac_data = (double*)malloc(dac_pt_cnt*sizeof(dac_data[0]));
#if CFG_DIGOUT_ENABLE
    dout_data = (DWORD*)malloc(dout_pt_cnt*sizeof(dout_data[0]));
#endif

    if ((dac_data == NULL) || (wrds == NULL)
#if CFG_DIGOUT_ENABLE
            || (dout_data == NULL)
#endif
            ) {
        err = LTR_ERROR_MEMORY_ALLOC;
    } else {
        for (i=0; i < ch_pt_cnt; i++) {
            for (ch=0; ch < phltr35->State.SDRAMChCnt; ch++) {
                dac_data[phltr35->State.SDRAMChCnt*i + ch] = sig_amps[ch]*sin(2.*M_PI*i*sig_freq_mul[ch]/ch_pt_cnt) + sig_offs[ch];
            }
    #if CFG_DIGOUT_ENABLE
            dout_data[i] = i & 0xFFFF;
    #endif
        }

        err = LTR35_PrepareData(phltr35, dac_data, &dac_pt_cnt,
#if CFG_DIGOUT_ENABLE
                                   dout_data, &dout_pt_cnt,
#else
                                   NULL, 0,
#endif
                                   LTR35_PREP_FLAGS_VOLT, wrds, &snd_wrds_cnt);
        if (err!=LTR_OK) {
            fprintf(stderr, "   (%d) : %s!\n", err, LTR35_GetErrorString(err));
        }

        if (!err) {
            INT sent_size = 0;

            /*  ,      ,   
             *  ,     .
             *         ,   
             *     .   
             *   Send   
             */
            while (!f_out && !err && (sent_size < (INT)snd_wrds_cnt)) {
                INT cur_sent = LTR35_Send(phltr35, &wrds[sent_size], snd_wrds_cnt - sent_size, 500);
                if (cur_sent < 0) {
                    err = cur_sent;
                    fprintf(stderr, "   (%d) : %s!\n", err, LTR35_GetErrorString(err));
                } else {
                    sent_size += cur_sent;
                }
#ifdef _WIN32
                /*      */
                if (err==LTR_OK) {
                    if (_kbhit())
                        f_out = 1;
                }
#endif
            }
        }
    }
    free(wrds);
    free(dac_data);
#if CFG_DIGOUT_ENABLE
    free(dout_data);
#endif

    return err;
}





int main(int argc, char** argv) {
    t_open_param par;
    INT err = LTR_OK;

#ifndef _WIN32
    struct sigaction sa;
    memset(&sa, 0, sizeof(sa));
    /*   Linux      ,
           */
    sa.sa_handler = f_abort_handler;
    sigaction(SIGTERM, &sa, NULL);
    sigaction(SIGINT, &sa, NULL);
    sigaction(SIGABRT, &sa, NULL);
#endif

#ifdef _WIN32
    /*      ... */
    setlocale(LC_ALL, "");
#endif

    err = f_get_params(argc, argv, &par);

    if (err == LTR_OK) {
        INT close_err;
        TLTR35 hltr35;
        LTR35_Init(&hltr35);
        /*     */
        err = LTR35_Open(&hltr35, par.addr, LTRD_PORT_DEFAULT, par.serial, par.slot);
        if (err!=LTR_OK) {
            fprintf(stderr, "     .  %d (%s)\n",
                    err, LTR35_GetErrorString(err));
        } else {

            double fnd_freq;

            printf("  !\n");
            printf("       = %s\n", hltr35.ModuleInfo.Name);
            printf("        = %s\n", hltr35.ModuleInfo.Serial);
            printf("          = LTR35-%d\n", hltr35.ModuleInfo.Modification);
            printf("   PLD         = %d\n", hltr35.ModuleInfo.VerPLD);
            printf("           = %d\n", hltr35.ModuleInfo.VerFPGA);
            printf("           = %d\n", hltr35.ModuleInfo.DacChCnt);
            printf("      = %d\n", hltr35.ModuleInfo.DoutLineCnt);

            fflush(stdout);

            /*    */
            err = LTR35_FillOutFreq(&hltr35.Cfg, CFG_OUT_FREQ, &fnd_freq);
            if (err==LTR_OK) {
                BYTE ch_num;
#if CFG_FORMAT_24
                hltr35.Cfg.OutDataFmt = LTR35_OUTDATA_FORMAT_24;
#else
                hltr35.Cfg.OutDataFmt = LTR35_OUTDATA_FORMAT_20;
#endif
                hltr35.Cfg.OutMode = LTR35_OUT_MODE_CYCLE;
                /*   CFG_USED_DAC_CH_CNT  */
                for (ch_num = 0; ch_num < CFG_USED_DAC_CH_CNT; ch_num++) {
                    hltr35.Cfg.Ch[ch_num].Enabled = TRUE;
                    hltr35.Cfg.Ch[ch_num].Source = LTR35_CH_SRC_SDRAM;
                    hltr35.Cfg.Ch[ch_num].Output = LTR35_DAC_OUT_FULL_RANGE; /*  1:1 */
                }

                /*    */
                err = LTR35_Configure(&hltr35);
                if (err != LTR_OK) {
                    fprintf(stderr, "   .  %d (%s)\n",
                            err, LTR35_GetErrorString(err));
                }
            }

            /*      ,    
                      */
            if (err==LTR_OK) {                
                err = f_send_data(&hltr35, CFG_OUT_CH_PT_CNT);
            }

            if (err==LTR_OK) {
                /*        */
                err = LTR35_SwitchCyclePage(&hltr35, 0, 30000);
                if (err!=LTR_OK) {
                    fprintf(stderr, "    (%d) : %s!\n",
                            err, LTR35_GetErrorString(err));
                } else {
                    printf("  !\n"); fflush(stdout);
                }
            }

            if (err == LTR_OK) {
                printf("  .    %s\n",
#ifdef _WIN32
                       " "
#else
                       "CTRL+C"
#endif
                       );
                fflush(stdout);
                /*       -
                 * .      */
                while ((err==LTR_OK) && !f_out) {
                    LTRAPI_SLEEP_MS(100);
#ifdef _WIN32
                    /*      */
                    if (err==LTR_OK) {
                        if (_kbhit())
                            f_out = 1;
                    }
#endif
                }
            }

            /*   ,     */
            if (hltr35.State.Run) {
                INT stop_err = LTR35_Stop(&hltr35, 0);
                if (stop_err!=LTR_OK) {
                    fprintf(stderr, "    .  %d:%s\n",
                            stop_err, LTR35_GetErrorString(stop_err));
                    if (err==LTR_OK)
                        err = stop_err;
                } else {
                    printf("   .\n");
                }
            }
        }

        /*     */
        close_err = LTR35_Close(&hltr35);
        if (close_err!=LTR_OK) {
            fprintf(stderr, "     .  %d:%s\n",
                    close_err, LTR35_GetErrorString(close_err));
            if (err==LTR_OK)
                err = close_err;
        } else {
            printf("    .\n");
        }
    }

    return err;
}
